package djvalidate

import (
	"errors"
	openrtb3 "openrtb/openrtb3"

	openrtb "openrtb/openrtb2.5"
)

// Function for validating request
func ValidateRequest3(req *openrtb3.Request) []error {
	if req.ID == "" {
		return []error{errors.New("openrtb: request ID missing")}
	} else if len(req.Item) == 0 {
		return []error{errors.New("openrtb: request has no item object")}
	} else if req.Context.Site != nil && req.Context.App != nil {
		return []error{errors.New("openrtb: request has multiple inventory sources")}
	}
	for _, item := range req.Item {
		if err := (&item).Validate(); err != nil {
			return []error{errors.New("openrtb: impression Format Error")}
		}
	}
	return nil
}

func ValidateRequest25(req *openrtb.BidRequest) []error {
	if req.ID == "" {
		return []error{errors.New("openrtb: request ID missing")}
	} else if len(req.Imp) == 0 {
		return []error{errors.New("openrtb: request has no impressions")}
	} else if req.Site != nil && req.App != nil {
		return []error{errors.New("openrtb: request has multiple inventory sources")}
	}
	for _, imp := range req.Imp {
		if err := (&imp).Validate(); err != nil {
			return []error{errors.New("openrtb: impression Format Error")}
		}
	}
	return nil
}
